/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.blocks;

import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class VerticalSlabBlockEntity
extends BlockEntity {
    private BlockState referredSlabState = null;

    public VerticalSlabBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)JustVerticalSlabsLoader.VERTICAL_SLAB_BLOCK_ENTITY.get(), pos, state);
    }

    @Nullable
    public BlockState getReferredSlabState() {
        return this.referredSlabState;
    }

    public void m_183515_(CompoundTag tag) {
        this.saveReferredSlabState(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadReferredSlabState(tag);
    }

    public CompoundTag m_5995_() {
        return this.saveReferredSlabState(super.m_5995_());
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public ModelData getModelData() {
        return VerticalSlabUtils.buildModelData(this.referredSlabState);
    }

    private CompoundTag saveReferredSlabState(CompoundTag tag) {
        if (this.referredSlabState != null) {
            VerticalSlabUtils.putReferredSlabState(tag, this.referredSlabState);
        }
        return tag;
    }

    private void loadReferredSlabState(CompoundTag tag) {
        CompoundTag referredSlabStateTag = tag.m_128469_("referredSlabState");
        if (referredSlabStateTag != null) {
            this.referredSlabState = NbtUtils.m_129241_((CompoundTag)referredSlabStateTag);
        } else {
            JustVerticalSlabsLoader.LOGGER.warn("No referredSlabState Tag could be found while loading NBTs for Vertical Slab in position [" + this.m_58899_().m_123341_() + ", " + this.m_58899_().m_123342_() + ", " + this.m_58899_().m_123343_() + "].");
            this.referredSlabState = null;
        }
    }
}

